/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.sales.controller;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.BaseController;
import itx.core.web.WebRequest;
import itx.erp.sales.model.SlotitemDay;
import itx.erp.sales.model.SlotitemHour;
import itx.erp.sales.model.SlotitemMonth;
import itx.erp.sales.model.SlotitemWeek;
import itx.erp.sales.model.Slotplan;
import itx.erp.sales.model.SlotplanPricetype;
import itx.erp.sales.service.SlotService;
import itx.erp.sales.validator.SlotitemHourValidator;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jtbcore.exception.JTBException;
import jtbcore.model.KeyValueList;
import jtbcore.util.StringUtil;

public class SlotConfigController
extends BaseController {
    protected SlotService slotService;

    public SlotService getSlotService() {
        return this.slotService;
    }

    public void setSlotService(SlotService slotService) {
        this.slotService = slotService;
    }

    @Override
    public void handleRequest(WebRequest webRequest) throws Exception {
        this.executeAction(webRequest);
    }

    public void baseDataAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        List<SlotplanPricetype> pricetypes = this.slotService.readPricetypes();
        HashMap<String, List<SlotplanPricetype>> result = new HashMap<String, List<SlotplanPricetype>>();
        result.put("pricetypes", pricetypes);
        req.renderJson(result);
    }

    public void indexAction(WebRequest req) {
    }

    public void listAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        List<Slotplan> slotplans = this.slotService.listSlotplans();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("slotplans", slotplans);
        result.put("success", true);
        req.renderJson(result);
    }

    public void viewAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        Integer slotplanId = req.getParamInt("slotplanId");
        Slotplan p = this.slotService.readSlotplan(slotplanId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("slotplan", p);
        result.put("success", true);
        req.renderJson(result);
    }

    public void saveSlotplanAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        Integer slotplanId = req.getParamInt("slotplanId");
        Slotplan sp = null;
        sp = slotplanId != null ? this.slotService.readSlotplan(slotplanId) : new Slotplan();
        sp.setName(req.getParameter("name"));
        sp.setDefaultSlotType(req.getParameter("defaultSlotType"));
        if ("hour".equals(sp.getDefaultSlotType())) {
            sp.setStartHour(req.getParamInt("startHour"));
            sp.setEndHour(req.getParamInt("endHour"));
            SlotitemHourValidator siValidator = new SlotitemHourValidator();
            List<KeyValueList> hourSlots = req.getKvl().getList("hourSlots");
            sp.setSlotitemHours(new ArrayList<SlotitemHour>());
            int x = 0;
            while (x < hourSlots.size()) {
                KeyValueList kvl = hourSlots.get(x);
                SlotitemHour si = new SlotitemHour();
                si.setStartTime(kvl.getValue("startTime"));
                si.setDuration(kvl.getValueInt("duration"));
                si.setSlotplanPricetypeId(kvl.getValueInt("pricetypeId"));
                String days = StringUtil.join(",", kvl.getArrayList("days"));
                si.setDays(days);
                if (siValidator.validate(si)) {
                    sp.getSlotitemHours().add(si);
                }
                ++x;
            }
        }
        if ("day".equals(sp.getDefaultSlotType())) {
            sp.getSlotitemDays().clear();
            KeyValueList kvldays = req.getKvl().getObject("days");
            int x = 1;
            while (x <= 7) {
                KeyValueList kvlday = kvldays.getObject(Integer.toString(x));
                SlotitemDay sd = new SlotitemDay();
                sd.setDayno(x);
                sd.setActive(kvlday.getValueBool("active"));
                sd.setSlotplanPricetypeId(kvlday.getValueInt("slotplanPricetypeId"));
                sp.getSlotitemDays().add(sd);
                ++x;
            }
        }
        if ("week".equals(sp.getDefaultSlotType())) {
            sp.getSlotitemWeeks().clear();
            KeyValueList kvlweeks = req.getKvl().getObject("weeks");
            int x = 1;
            while (x <= 53) {
                KeyValueList kvlweek = kvlweeks.getObject(Integer.toString(x));
                SlotitemWeek sw = new SlotitemWeek();
                sw.setWeekno(x);
                sw.setActive(kvlweek.getValueBool("active"));
                sw.setSlotplanPricetypeId(kvlweek.getValueInt("slotplanPricetypeId"));
                sp.getSlotitemWeeks().add(sw);
                ++x;
            }
        }
        if ("month".equals(sp.getDefaultSlotType())) {
            sp.getSlotitemMonths().clear();
            KeyValueList kvlmonths = req.getKvl().getObject("months");
            int x = 1;
            while (x <= 12) {
                KeyValueList kvlmonth = kvlmonths.getObject(Integer.toString(x));
                SlotitemMonth sm = new SlotitemMonth();
                sm.setMonthno(x);
                sm.setActive(kvlmonth.getValueBool("active"));
                sm.setSlotplanPricetypeId(kvlmonth.getValueInt("slotplanPricetypeId"));
                sp.getSlotitemMonths().add(sm);
                ++x;
            }
        }
        this.slotService.saveSlotplan(sp);
        HashMap<String, Comparable<Boolean>> result = new HashMap<String, Comparable<Boolean>>();
        result.put("success", Boolean.valueOf(true));
        result.put("slotplanId", sp.getSlotplanId());
        req.renderJson(result);
    }

    public void deleteSlotplanAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        Integer slotplanId = req.getParamInt("slotplanId");
        this.slotService.deleteSlotplan(slotplanId);
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("success", true);
        req.renderJson(result);
    }
}

